package ru.yandex.chemodan.app.docviewer.copy.provider;

import ru.yandex.bolts.collection.Option;
import ru.yandex.chemodan.app.docviewer.copy.ActualUri;
import ru.yandex.chemodan.app.docviewer.copy.DocumentSourceInfo;
import ru.yandex.chemodan.app.docviewer.disk.mpfs.MpfsUrlHelper;
import ru.yandex.chemodan.app.docviewer.disk.resource.DiskPrivateFileId;
import ru.yandex.chemodan.app.docviewer.disk.resource.DiskResourceId;
import ru.yandex.misc.io.http.UrlUtils;
import ru.yandex.misc.lang.StringUtils;

/**
 * @author akirakozov
 */
public class DiskUrlProvider extends DiskBaseUrlProvider {

    public DiskUrlProvider(MpfsUrlHelper mpfsUrlHelper) {
        super("ya-disk", mpfsUrlHelper);
    }

    @Override
    public String rewriteUrl(DocumentSourceInfo source) {
        String path = StringUtils.substringAfter(source.getOriginalUrl(), "://");
        return mpfsUrlHelper.getDirectUrl(source.getUid(), path);
    }

    @Override
    public Option<DiskResourceId> getDiskResourceId(ActualUri uri) {
        Option<String> path = getPathQueryParameter(uri);
        return path.isPresent() ? Option.of(new DiskPrivateFileId(path.get())) : Option.empty();
    }

    @Override
    public boolean isSupportedActualUri(ActualUri actualUri) {
        String host = actualUri.getUri().getHost();
        Option<String> path = getPathQueryParameter(actualUri);
        return StringUtils.equals(mpfsUrlHelper.getMpfsHost(), host) && path.isPresent();
    }

    private Option<String> getPathQueryParameter(ActualUri uri) {
        return UrlUtils.getQueryParameterFromUrl(uri.getUriString(), "path");
    }
}
