package ru.yandex.chemodan.app.docviewer.copy.provider;

import ru.yandex.bolts.collection.Option;
import ru.yandex.chemodan.app.docviewer.copy.ActualUri;
import ru.yandex.chemodan.app.docviewer.copy.DocumentSourceInfo;
import ru.yandex.chemodan.app.docviewer.disk.mpfs.MpfsUrlHelper;
import ru.yandex.chemodan.app.docviewer.disk.resource.DiskPrivateVersioningFileId;
import ru.yandex.chemodan.app.docviewer.disk.resource.DiskResourceId;
import ru.yandex.misc.io.http.UrlUtils;
import ru.yandex.misc.lang.StringUtils;
import ru.yandex.misc.lang.Validate;

/**
 * GET/json/versioning_get_version?uid=<UID>&path=<PATH>&version_id=<VERSION_ID>
 * ya-disk-version://version:path
 * @author vpronto
 */
public class DiskUrlVersioningProvider extends DocumentUrlProvider {

    private final MpfsUrlHelper mpfsUrlHelper;
    public DiskUrlVersioningProvider(MpfsUrlHelper mpfsUrlHelper) {
        super("ya-disk-version");
        this.mpfsUrlHelper = mpfsUrlHelper;
    }

    @Override
    public String rewriteUrl(DocumentSourceInfo source) {
        String path = StringUtils.substringAfter(source.getOriginalUrl(), "://");
        String[] split = path.split(":", 2);
        Validate.isTrue(split.length == 2, "Can't get find version");
        return mpfsUrlHelper.getVersioningUrl(source.getUid(), split[1], split[0]);
    }

    @Override
    public Option<DiskResourceId> getDiskResourceId(ActualUri uri) {
        Option<String> path = getPathQueryParameter(uri);
        return path.isPresent() ? Option.of(new DiskPrivateVersioningFileId(path.get())) : Option.empty();
    }

    @Override
    public boolean isSupportedActualUri(ActualUri actualUri) {
        String host = actualUri.getUri().getHost();
        Option<String> path = getPathQueryParameter(actualUri);
        return StringUtils.equals(mpfsUrlHelper.getMpfsHost(), host) && path.isPresent();
    }

    private Option<String> getPathQueryParameter(ActualUri uri) {
        return UrlUtils.getQueryParameterFromUrl(uri.getUriString(), "version_id");
    }
}
