package ru.yandex.chemodan.app.docviewer.copy.provider;

import ru.yandex.bolts.collection.Cf;
import ru.yandex.bolts.collection.MapF;
import ru.yandex.bolts.collection.Option;
import ru.yandex.bolts.function.Function1B;
import ru.yandex.chemodan.app.docviewer.copy.ActualUri;
import ru.yandex.chemodan.app.docviewer.copy.DocumentSourceInfo;
import ru.yandex.chemodan.app.docviewer.disk.resource.DiskResourceId;
import ru.yandex.misc.lang.StringUtils;
import ru.yandex.misc.log.mlf.Logger;
import ru.yandex.misc.log.mlf.LoggerFactory;

/**
 * @author akirakozov
 */
public abstract class DocumentUrlProvider {

    private static final Logger logger = LoggerFactory.getLogger(DocumentUrlProvider.class);

    private final String scheme;

    public DocumentUrlProvider(String scheme) {
        this.scheme = scheme;
        logger.info("Inited scheme: {}", scheme);
    }

    public abstract String rewriteUrl(DocumentSourceInfo source);

    public abstract Option<DiskResourceId> getDiskResourceId(ActualUri uri);

    public String getScheme() {
        return scheme;
    }

    public String getUrlPrefix() {
        return getScheme() + "://";
    }

    public boolean isSupportedUrl(String url) {
        return StringUtils.startsWith(url, getUrlPrefix());
    }

    public abstract boolean isSupportedActualUri(ActualUri actualUri);

    public boolean isYaTeamServiceProvider() {
        return false;
    }

    public static Function1B<DocumentUrlProvider> isSupportedUrlF(final String url) {
        return urlProvider -> urlProvider.isSupportedUrl(url);
    }

    public static Function1B<DocumentUrlProvider> isSupportedActualUriF(final ActualUri actualUri) {
        return urlProvider -> urlProvider.isSupportedActualUri(actualUri);
    }

    public MapF<String, String> getSpecificHeaders() {
        return Cf.map();
    }
}
