package ru.yandex.chemodan.app.docviewer.copy.provider;

import org.jetbrains.annotations.NotNull;

import ru.yandex.bolts.collection.Option;
import ru.yandex.chemodan.app.docviewer.copy.ActualUri;
import ru.yandex.chemodan.app.docviewer.copy.DocumentSourceInfo;
import ru.yandex.chemodan.app.docviewer.disk.resource.DiskResourceId;
import ru.yandex.misc.lang.StringUtils;
import ru.yandex.misc.lang.Validate;

/**
 * @author akirakozov
 */
public class FemidaUrlProvider extends DocumentUrlProvider {
    private final String femidaHost;

    public FemidaUrlProvider(String femidaHost) {
        super("ya-femida");
        this.femidaHost = femidaHost;
    }

    @Override
    public String rewriteUrl(DocumentSourceInfo source) {
        Validate.isTrue(source.getUid().isYandexTeamRu(), "Femida works only with ya-team users");
        return getFemidaUrlBaseStartPart() + getDocumentId(source.getOriginalUrl());
    }

    @NotNull
    private String getFemidaUrlBaseStartPart() {
        return "https://" + femidaHost + "/api/attachments/";
    }

    private String getDocumentId(String originalUrl) {
        return StringUtils.substringAfter(originalUrl, getUrlPrefix());
    }

    @Override
    public Option<DiskResourceId> getDiskResourceId(ActualUri uri) {
        return Option.empty();
    }

    public boolean isYaTeamServiceProvider() {
        return true;
    }

    @Override
    public boolean isSupportedActualUri(ActualUri actualUri) {
        return StringUtils.startsWith(actualUri.getUriString(), getFemidaUrlBaseStartPart());
    }

}
