package ru.yandex.chemodan.app.docviewer.copy.provider;

import ru.yandex.bolts.collection.Cf;
import ru.yandex.bolts.collection.Option;
import ru.yandex.chemodan.app.docviewer.copy.ActualUri;
import ru.yandex.chemodan.app.docviewer.copy.DocumentSourceInfo;
import ru.yandex.chemodan.app.docviewer.disk.resource.DiskResourceId;
import ru.yandex.chemodan.app.docviewer.disk.resource.MailAttachmentId2;
import ru.yandex.chemodan.util.HostBasedSwitch;
import ru.yandex.misc.io.http.UrlUtils;
import ru.yandex.misc.lang.StringUtils;
import ru.yandex.misc.lang.Validate;

/**
 * @author akirakozov
 */
public class MailUrlProvider2 extends DocumentUrlProvider {

    private final HostBasedSwitch enableNewSchema = new HostBasedSwitch("use-mail-meta-host");

    private final String mailHostPort;
    private final String mailYtHostPort;

    private final String mailMetaHostPort;
    private final String mailYtMetaHostPort;

    public MailUrlProvider2(String mailHost, String mailYtHost, String mailMetaHost, String mailYtMetaHost, int port) {
        super("ya-mail");
        this.mailHostPort = "https://" + mailHost + ":" + port;
        this.mailYtHostPort = "https://" + mailYtHost + ":" + port;

        this.mailMetaHostPort = "https://" + mailMetaHost;
        this.mailYtMetaHostPort = "https://" + mailYtMetaHost;
    }

    @Override
    public String rewriteUrl(DocumentSourceInfo source) {
        Validate.isTrue(source.getUid().isAuthenticated(), "user is not authenticated");

        String withoutSchemeUrl = StringUtils.substringAfter(source.getOriginalUrl(), "://");
        String mid = StringUtils.substringBefore(withoutSchemeUrl, "/");
        String part = StringUtils.substringAfter(withoutSchemeUrl, "/");

        String hostPort;
        String path;
        if (enableNewSchema.get()) {
            hostPort = source.getUid().isYandexTeamRu() ? mailYtMetaHostPort : mailMetaHostPort;
            path = "/mimes";
        } else {
            hostPort = source.getUid().isYandexTeamRu() ? mailYtHostPort : mailHostPort;
            path = "/dv-mimes";
        }

        String resultUrl = UrlUtils.addParameters(hostPort + path,
                Cf.<String, String>map()
                .plus1("uid", source.getUid().toString())
                .plus1("mid", mid)
                .plus1("with_mulca", "yes")
                .plus1("with_inline", "yes"));

        // this parameter is not used by wmi, we append it only to create unique url for
        // different attachments from one mail
        resultUrl = UrlUtils.addParameter(resultUrl, "part", part);
        return resultUrl;
    }

    @Override
    public Option<DiskResourceId> getDiskResourceId(ActualUri uri) {
        String url = uri.getUriString();
        String mid = UrlUtils.getQueryParameterFromUrl(url, "mid").get();
        String hid = UrlUtils.getQueryParameterFromUrl(url, "part").get();
        return Option.of(new MailAttachmentId2(mid, hid));
    }

    @Override
    public boolean isSupportedActualUri(ActualUri actualUri) {
        String uriString = actualUri.getUriString();
        return Cf.list(mailHostPort, mailYtHostPort).find(uriString::startsWith).isPresent();
    }
}
