package ru.yandex.chemodan.app.docviewer.copy.provider;

import ru.yandex.chemodan.app.docviewer.copy.ActualUri;
import ru.yandex.inside.mds.MdsActions;
import ru.yandex.inside.mds.MdsFileKey;
import ru.yandex.inside.mds.MdsUrlUtils;
import ru.yandex.misc.ip.HostPort;
import ru.yandex.misc.lang.StringUtils;

/**
 * @author akirakozov
 */
public abstract class MdsBaseUrlProvider  extends DocumentUrlProvider {

    protected final String mdsNamespace;
    protected final HostPort hostPort;

    public MdsBaseUrlProvider(String scheme, String mdsNamespace, HostPort hostPort) {
        super(scheme);
        this.mdsNamespace = mdsNamespace;
        this.hostPort = hostPort;
    }

    @Override
    public boolean isSupportedActualUri(ActualUri actualUri) {
        return StringUtils.startsWith(actualUri.getUriString(),
                MdsUrlUtils.toUrl(hostPort) + "/get-" + mdsNamespace);
    }

    protected String getUrlByMdsKey(String serializedKey) {
        MdsFileKey key = MdsFileKey.parse(serializedKey);
        return MdsUrlUtils.actionUrl(hostPort, MdsActions.GET, mdsNamespace, key);
    }
}
