package ru.yandex.chemodan.app.docviewer.copy.provider;

import ru.yandex.bolts.collection.Option;
import ru.yandex.chemodan.app.docviewer.copy.ActualUri;
import ru.yandex.chemodan.app.docviewer.copy.DocumentSourceInfo;
import ru.yandex.chemodan.app.docviewer.disk.resource.DiskResourceId;
import ru.yandex.inside.mulca.MulcaGateUrl;
import ru.yandex.inside.mulca.MulcaId;
import ru.yandex.misc.lang.StringUtils;
import ru.yandex.misc.lang.Validate;

/**
 * @author akirakozov
 */
public class MulcaBaseUrlProvider extends DocumentUrlProvider {

    private final String mulcaGateUrlString;
    private final MulcaGateUrl mulcaGateUrl;

    protected MulcaBaseUrlProvider(String scheme, String mulcaGateUrlString, String service, String namespace) {
        super(scheme);
        this.mulcaGateUrlString = mulcaGateUrlString;
        this.mulcaGateUrl = new MulcaGateUrl(mulcaGateUrlString).withService(service).withNamespace(namespace);
    }

    private MulcaId parseMulcaIdFromUrl(String url) {
        String[] parts = StringUtils.substringAfter(url, "://").split("/");
        Validate.isTrue(parts.length > 0, "Incorrect mulca specific format: ", url);
        return MulcaId.valueOf(parts[0], parts.length > 1 ? parts[1] : "");
    }

    @Override
    public String rewriteUrl(DocumentSourceInfo source) {
        return mulcaGateUrl.buildDownloadUri(parseMulcaIdFromUrl(source.getOriginalUrl())).toString();
    }

    @Override
    public Option<DiskResourceId> getDiskResourceId(ActualUri uri) {
        return Option.empty();
    }

    @Override
    public boolean isSupportedActualUri(ActualUri actualUri) {
        return StringUtils.startsWith(actualUri.getUriString(), mulcaGateUrlString);
    }
}
