package ru.yandex.chemodan.app.docviewer.copy.provider;

import ru.yandex.misc.lang.StringUtils;
import ru.yandex.misc.lang.Validate;

/**
 * @author akirakozov
 */
public class MulcaUrlProvider extends MulcaBaseUrlProvider {
    private static final String YA_MULCA = "mulca";

    public MulcaUrlProvider(String mulcaGateUrl, String mulcaService, String mulcaNamespace) {
        super(YA_MULCA, mulcaGateUrl, mulcaService, mulcaNamespace);
    }

    public static boolean isMulcaUrl(String uri) {
        return StringUtils.startsWith(uri, YA_MULCA + "://");
    }

    public static String getSerializedIdFromMulcaUrl(String uri) {
        Validate.isTrue(isMulcaUrl(uri), "Expected mulca url instead of ", uri);
        // XXX: mulca:// shuldn't contains parameters, but now it does: CHEMODAN-6695,
        // so we should remove parameters part from uri
        return StringUtils.substringBefore(StringUtils.substringAfter(uri, YA_MULCA + "://"), "/?");
    }
}
