package ru.yandex.chemodan.app.docviewer.copy.provider;

import ru.yandex.bolts.collection.Option;
import ru.yandex.chemodan.app.docviewer.copy.ActualUri;
import ru.yandex.chemodan.app.docviewer.copy.DocumentSourceInfo;
import ru.yandex.chemodan.app.docviewer.disk.resource.DiskResourceId;
import ru.yandex.misc.ip.HostPort;
import ru.yandex.misc.lang.StringUtils;

/**
 * @author akirakozov
 */
public class OtrsUrlProvider extends MdsBaseUrlProvider {
    public OtrsUrlProvider(HostPort hostPort) {
        super("otrs", "otrs", hostPort);
    }

    @Override
    public String rewriteUrl(DocumentSourceInfo source) {
        String serializedKey = StringUtils.substringBeforeLast(
                StringUtils.substringAfter(source.getOriginalUrl(), "otrs://MDS:"), "/");
        return getUrlByMdsKey(serializedKey);
    }

    @Override
    public Option<DiskResourceId> getDiskResourceId(ActualUri uri) {
        return Option.empty();
    }

    @Override
    public boolean isYaTeamServiceProvider() {
        return true;
    }
}
