package ru.yandex.chemodan.app.docviewer.copy.provider;

import java.net.URLEncoder;

import javax.annotation.Nonnull;

import lombok.SneakyThrows;

import ru.yandex.bolts.collection.Option;
import ru.yandex.chemodan.app.docviewer.copy.ActualUri;
import ru.yandex.chemodan.app.docviewer.copy.DocumentSourceInfo;
import ru.yandex.chemodan.app.docviewer.disk.resource.DiskResourceId;
import ru.yandex.misc.lang.StringUtils;

public class PracticumUrlProvider extends DocumentUrlProvider {

    private final String practicumHost;

    public PracticumUrlProvider(String practicumHost) {
        super("ya-practicum");
        this.practicumHost = practicumHost;
    }

    @SneakyThrows
    @Override
    public String rewriteUrl(DocumentSourceInfo source) {
        String key = StringUtils.substringAfter(source.getOriginalUrl(), getUrlPrefix());
        if (!key.startsWith("/")) {
            key = "/" + key;
        }
        return getApiUrlBaseStartPart() + URLEncoder.encode(key, "UTF-8");
    }

    @Override
    public Option<DiskResourceId> getDiskResourceId(ActualUri uri) {
        return Option.empty();
    }

    @Override
    public boolean isSupportedActualUri(ActualUri actualUri) {
        return StringUtils.startsWith(actualUri.getUriString(), getApiUrlBaseStartPart());
    }

    @Nonnull
    private String getApiUrlBaseStartPart() {
        return "https://" + practicumHost + "/docviewer/?path=";
    }
}
