package ru.yandex.chemodan.app.docviewer.copy.provider;

import ru.yandex.bolts.collection.Option;
import ru.yandex.chemodan.app.docviewer.copy.ActualUri;
import ru.yandex.chemodan.app.docviewer.copy.DocumentSourceInfo;
import ru.yandex.chemodan.app.docviewer.disk.resource.DiskResourceId;
import ru.yandex.misc.io.http.UrlUtils;
import ru.yandex.misc.lang.StringUtils;
import ru.yandex.misc.log.mlf.Logger;
import ru.yandex.misc.log.mlf.LoggerFactory;

/**
 * https://PROCU_HOST/api/attachments/doc?attachment=<file_id>&uid=<uid>
 * @author vpronto
 */
public class ProcuUrlProvider extends DocumentUrlProvider {

    private static final Logger logger = LoggerFactory.getLogger(ProcuUrlProvider.class);

    private final String procuDownloadUrlPath;

    public ProcuUrlProvider(String procuDownloadUrlPath) {
        super("ya-procu");
        this.procuDownloadUrlPath = "https://" + procuDownloadUrlPath + "/api/attachments/doc";
        logger.info("Init with url: {}", procuDownloadUrlPath);
    }

    @Override
    public String rewriteUrl(DocumentSourceInfo source) {
        String documentId = StringUtils.substringAfter(source.getOriginalUrl(), "://");

        return UrlUtils.addParameter(procuDownloadUrlPath,
                "attachment", documentId, "uid", Long.toString(source.getUid().getUid()));
    }

    @Override
    public Option<DiskResourceId> getDiskResourceId(ActualUri uri) {
        return Option.empty();
    }

    @Override
    public boolean isYaTeamServiceProvider() {
        return true;
    }

    @Override
    public boolean isSupportedActualUri(ActualUri actualUri) {
        return StringUtils.startsWith(actualUri.getUriString(), procuDownloadUrlPath);
    }
}
