package ru.yandex.chemodan.app.docviewer.copy.provider;

import org.springframework.beans.factory.annotation.Autowired;

import ru.yandex.bolts.collection.Option;
import ru.yandex.chemodan.app.docviewer.copy.ActualUri;
import ru.yandex.chemodan.app.docviewer.copy.DocumentSourceInfo;
import ru.yandex.chemodan.app.docviewer.disk.resource.DiskResourceId;
import ru.yandex.chemodan.app.docviewer.disk.resource.WebDocumentId;
import ru.yandex.chemodan.app.docviewer.utils.httpclient.MpfsHttpClient;
import ru.yandex.misc.lang.StringUtils;

/**
 * @author metal
 */
public class RealHttpUrlProvider extends DocumentUrlProvider {
    @Autowired
    private MpfsHttpClient mpfsHttpClient;

    public RealHttpUrlProvider(boolean isHttpsScheme) {
        super(isHttpsScheme ? "https" : "http");
    }

    @Override
    public String rewriteUrl(DocumentSourceInfo source) {
        return source.getOriginalUrl();
    }

    @Override
    public Option<DiskResourceId> getDiskResourceId(ActualUri uri) {
        return Option.of(new WebDocumentId(uri.getUriString(), mpfsHttpClient));
    }

    @Override
    public boolean isSupportedActualUri(ActualUri actualUri) {
        return StringUtils.startsWith(actualUri.getUriString(), getUrlPrefix());
    }
}
