package ru.yandex.chemodan.app.docviewer.copy.provider;

import javax.annotation.Nonnull;

import ru.yandex.bolts.collection.Option;
import ru.yandex.chemodan.app.docviewer.copy.ActualUri;
import ru.yandex.chemodan.app.docviewer.copy.DocumentSourceInfo;
import ru.yandex.chemodan.app.docviewer.disk.resource.DiskResourceId;
import ru.yandex.misc.lang.StringUtils;

/**
 * @author yashunsky
 */
public class SchoolbookUrlProvider extends DocumentUrlProvider {

    private final String schoolbookHost;

    public SchoolbookUrlProvider(String schoolbookHost) {
        super("ya-schoolbook");
        this.schoolbookHost = schoolbookHost;
    }

    @Override
    public String rewriteUrl(DocumentSourceInfo source) {
        String key = StringUtils.substringAfter(source.getOriginalUrl(), getUrlPrefix());
        return getApiUrlBaseStartPart() + key + "/";
    }

    @Override
    public Option<DiskResourceId> getDiskResourceId(ActualUri uri) {
        return null;
    }

    @Override
    public boolean isSupportedActualUri(ActualUri actualUri) {
        return StringUtils.startsWith(actualUri.getUriString(), getApiUrlBaseStartPart());
    }

    @Nonnull
    private String getApiUrlBaseStartPart() {
        return "https://" + schoolbookHost + "/api/v2/resources/";
    }
}
