package ru.yandex.chemodan.app.docviewer.copy.provider;

import org.springframework.beans.factory.annotation.Autowired;

import ru.yandex.bolts.collection.Option;
import ru.yandex.chemodan.app.docviewer.copy.ActualUri;
import ru.yandex.chemodan.app.docviewer.copy.DocumentSourceInfo;
import ru.yandex.chemodan.app.docviewer.disk.resource.DiskResourceId;
import ru.yandex.chemodan.app.docviewer.disk.resource.WebDocumentId;
import ru.yandex.chemodan.app.docviewer.utils.httpclient.MpfsHttpClient;
import ru.yandex.misc.io.http.UrlUtils;
import ru.yandex.misc.lang.StringUtils;

/**
 * @author akirakozov
 */
public class SerpUrlProvider extends DocumentUrlProvider {
    @Autowired
    private MpfsHttpClient mpfsHttpClient;

    private final String serpDownloadUrl;
    private final String realSchema;

    public SerpUrlProvider(String serpDownloadUrl, boolean isHttpsScheme) {
        super(isHttpsScheme ? "ya-serps" : "ya-serp");
        this.realSchema = isHttpsScheme ? "https://" : "http://";
        this.serpDownloadUrl = "http://" + serpDownloadUrl;
    }

    @Override
    public String rewriteUrl(DocumentSourceInfo source) {
        String urlWithoutSheme = StringUtils.substringAfter(source.getOriginalUrl(), getUrlPrefix());
        return UrlUtils.addParameter(serpDownloadUrl,
                "url", realSchema + urlWithoutSheme,
                "noconv", 1);
    }

    @Override
    public Option<DiskResourceId> getDiskResourceId(ActualUri uri) {
        Option<String> url = UrlUtils.getQueryParameterFromUrl(uri.getUriString(), "url");
        return url.isPresent() ? Option.of(new WebDocumentId(url.get(), mpfsHttpClient)) : Option.empty();
    }

    @Override
    public boolean isSupportedActualUri(ActualUri actualUri) {
        String uriString = actualUri.getUriString();
        Option<String> urlParameter = UrlUtils.getQueryParameterFromUrl(uriString, "url");
        return StringUtils.startsWith(uriString, serpDownloadUrl)
                && urlParameter.isPresent()
                && StringUtils.startsWith(urlParameter.get(), realSchema);
    }
}
