package ru.yandex.chemodan.app.docviewer.copy.provider;

import javax.annotation.Nonnull;

import ru.yandex.bolts.collection.Option;
import ru.yandex.chemodan.app.docviewer.copy.ActualUri;
import ru.yandex.chemodan.app.docviewer.copy.DocumentSourceInfo;
import ru.yandex.chemodan.app.docviewer.disk.resource.DiskResourceId;
import ru.yandex.misc.io.http.UrlUtils;
import ru.yandex.misc.lang.StringUtils;

public class UslugiUrlProvider extends DocumentUrlProvider {

    private final String uslugiHost;

    public UslugiUrlProvider(String uslugiHost) {
        super("uslugi");
        this.uslugiHost = uslugiHost;
    }

    @Override
    public String rewriteUrl(DocumentSourceInfo source) {
        String key = StringUtils.substringAfter(source.getOriginalUrl(), getUrlPrefix());
        return UrlUtils.addParameter(
                getApiUrlBaseStartPart(),
                "key", key
        );
    }

    @Override
    public Option<DiskResourceId> getDiskResourceId(ActualUri uri) {
        return Option.empty();
    }

    @Override
    public boolean isSupportedActualUri(ActualUri actualUri) {
        return StringUtils.startsWith(actualUri.getUriString(), getApiUrlBaseStartPart());
    }

    @Nonnull
    public String getApiUrlBaseStartPart() {
        return "https://" + uslugiHost + "/uslugi/api/get_user_file";
    }
}
