package ru.yandex.chemodan.app.docviewer.copy.provider;

import ru.yandex.bolts.collection.Cf;
import ru.yandex.bolts.collection.Option;
import ru.yandex.bolts.collection.SetF;
import ru.yandex.chemodan.app.docviewer.copy.ActualUri;
import ru.yandex.chemodan.app.docviewer.copy.DocumentSourceInfo;
import ru.yandex.chemodan.app.docviewer.disk.resource.DiskResourceId;
import ru.yandex.misc.io.http.UrlUtils;
import ru.yandex.misc.lang.StringUtils;
import ru.yandex.misc.lang.Validate;

/**
 * @author akirakozov
 */
public class WikiUrlProvider extends DocumentUrlProvider {

    private final String wikiDownloadUrlPath;
    private final SetF<String> possibleWikiHosts;
    private final boolean isYaTeamWiki;

    public WikiUrlProvider(String wikiDownloadUrlPath, SetF<String> wikiHosts, boolean isYaTeamWiki) {
        super("ya-wiki");
        this.wikiDownloadUrlPath = wikiDownloadUrlPath;
        this.isYaTeamWiki = isYaTeamWiki;
        this.possibleWikiHosts = createPossibleUrls(wikiHosts, isYaTeamWiki);
    }

    private SetF<String> createPossibleUrls(SetF<String> hosts, boolean isYaTeamWiki) {
        if (isYaTeamWiki) {
            hosts = hosts.plus(Cf.list(
                // Temporary hardcode for migration st.yandex-team.ru/WIKI-9579
                "wiki.yandex-team.ru", "wiki.evaluation.yandex-team.ru",
                "wiki-api.yandex-team.ru", "wiki-api.evaluation.yandex-team.ru"));
        }

        return hosts;
    }

    @Override
    public String rewriteUrl(DocumentSourceInfo source) {
        String withoutSchemeUrl = StringUtils.substringAfter(source.getOriginalUrl(), "://");
        String host = StringUtils.substringBefore(withoutSchemeUrl, "/");
        String path = StringUtils.substringAfter(withoutSchemeUrl, "/");

        Validate.isTrue(possibleWikiHosts.containsTs(host), "Unknown wiki host " + host);
        String resultUrl = "https://" + host + wikiDownloadUrlPath;
        resultUrl = UrlUtils.addParameter(resultUrl, "fileid", path);
        return resultUrl;
    }

    @Override
    public Option<DiskResourceId> getDiskResourceId(ActualUri uri) {
        return Option.empty();
    }

    @Override
    public boolean isYaTeamServiceProvider() {
        return isYaTeamWiki;
    }

    @Override
    public boolean isSupportedActualUri(ActualUri actualUri) {
        String uriString = actualUri.getUriString();
        return possibleWikiHosts.map(host -> "https://" + host).find(uriString::startsWith).isPresent();
    }

    @Override
    public boolean isSupportedUrl(String url) {
        return possibleWikiHosts.map(host -> getUrlPrefix() + host).find(url::startsWith).isPresent();
    }
}
