package ru.yandex.chemodan.app.docviewer.copy.provider;

import ru.yandex.bolts.collection.Option;
import ru.yandex.chemodan.app.docviewer.copy.ActualUri;
import ru.yandex.chemodan.app.docviewer.copy.DocumentSourceInfo;
import ru.yandex.chemodan.app.docviewer.disk.resource.DiskResourceId;
import ru.yandex.chemodan.app.docviewer.disk.resource.YaBroResourceId;
import ru.yandex.inside.mds.MdsFileKey;
import ru.yandex.misc.ip.HostPort;
import ru.yandex.misc.lang.StringUtils;
import ru.yandex.misc.net.uri.Uri2;

/**
 * @author akirakozov
 */
public class YaBroUrlProvider extends MdsBaseUrlProvider {
    public YaBroUrlProvider(String mdsNamespace, HostPort hostPort) {
        super("ya-browser", mdsNamespace, hostPort);
    }

    @Override
    public String rewriteUrl(DocumentSourceInfo source) {
        String serializedKey = StringUtils.substringBefore(
                StringUtils.substringAfter(source.getOriginalUrl(), getUrlPrefix()), "?");

        return getUrlByMdsKey(serializedKey);
    }

    @Override
    public Option<DiskResourceId> getDiskResourceId(ActualUri uri) {
        String serializedKey = StringUtils.join(
                Uri2.parse(uri.getUri().toString()).getPathComponents().drop(1), "/");
        MdsFileKey key = MdsFileKey.parse(serializedKey);
        return Option.of(new YaBroResourceId(key));
    }

}
