package ru.yandex.chemodan.app.docviewer.copy.resourcemanagers;

import org.apache.http.HttpResponse;
import org.apache.http.HttpStatus;

import ru.yandex.chemodan.app.docviewer.states.ErrorCode;
import ru.yandex.chemodan.app.docviewer.states.UserException;

/**
 * @author yashunsky
 */
public class ResponseHandlerUtils {
    public static void checkStatusCode(HttpResponse response) {
        int statusCode = response.getStatusLine().getStatusCode();
        if (statusCode == HttpStatus.SC_NOT_FOUND) {
            throw new UserException(ErrorCode.FILE_NOT_FOUND);
        } else if (statusCode == HttpStatus.SC_FORBIDDEN) {
            throw new UserException(ErrorCode.FILE_IS_FORBIDDEN);
        } else if (statusCode != HttpStatus.SC_OK) {
            throw new UserException(ErrorCode.UNABLE_TO_RETRIEVE_FILE, "status-code: " + statusCode);
        }
    }
}
