package ru.yandex.chemodan.app.docviewer.copy.resourcemanagers;

import java.io.IOException;
import java.net.URI;
import java.nio.charset.StandardCharsets;

import com.fasterxml.jackson.databind.JsonNode;
import lombok.AllArgsConstructor;
import org.apache.commons.io.IOUtils;
import org.apache.http.HttpResponse;
import org.apache.http.client.HttpClient;
import org.apache.http.client.ResponseHandler;
import org.apache.http.client.methods.HttpGet;
import org.apache.http.client.methods.HttpUriRequest;

import ru.yandex.chemodan.app.docviewer.states.UserException;
import ru.yandex.chemodan.util.json.JsonNodeUtils;
import ru.yandex.misc.io.http.apache.v4.ApacheHttpClientUtils;

/**
 * @author yashunsky
 */
@AllArgsConstructor
public class SchoolbookApiManager {
    private final HttpClient httpClient;

    public URI getStorageUri(URI uri) {
        HttpUriRequest request = new HttpGet(uri);
        return ApacheHttpClientUtils.execute(request, httpClient, new SchoolbookResponseHandler());
    }

    public boolean isUriAccessible(URI uri) {
        try {
            getStorageUri(uri);
            return true;
        } catch (UserException e) {
            return false;
        }
    }

    private static class SchoolbookResponseHandler implements ResponseHandler<URI> {
        @Override
        public URI handleResponse(HttpResponse response) throws IOException {
            ResponseHandlerUtils.checkStatusCode(response);
            JsonNode jsonNode =
                    JsonNodeUtils.getNode(IOUtils.toString(response.getEntity().getContent(), StandardCharsets.UTF_8));
            String url = jsonNode.get("file").asText();
            return URI.create(url);
        }
    }
}
