package ru.yandex.chemodan.app.docviewer.copy.resourcemanagers;

import java.net.URI;

import lombok.AllArgsConstructor;
import org.apache.http.client.HttpClient;
import org.apache.http.client.methods.HttpGet;
import org.apache.http.client.methods.HttpUriRequest;

import ru.yandex.chemodan.app.docviewer.copy.provider.TrackerUrlProvider;
import ru.yandex.chemodan.app.docviewer.states.ErrorCode;
import ru.yandex.chemodan.app.docviewer.states.UserException;
import ru.yandex.inside.passport.tvm2.UserTicketHolder;
import ru.yandex.misc.io.http.UrlUtils;
import ru.yandex.misc.io.http.apache.v4.ApacheHttpClientUtils;

/**
 * @author yashunsky
 */
@AllArgsConstructor
public class TrackerApiManager {

    private final HttpClient httpClient;

    public URI getStorageUri(URI uri) {
        String url = uri.toString();
        String orgId = UrlUtils.getQueryParameterFromUrl(url, TrackerUrlProvider.ORG_ID_PARAM)
                .getOrThrow(() -> new UserException(ErrorCode.FILE_IS_FORBIDDEN, "No org id provided"));
        UserTicketHolder.get()
                .getOrThrow(() -> new UserException(ErrorCode.FILE_IS_FORBIDDEN, "No tvm user ticket provider"));

        String realUrl = url.substring(0, url.indexOf('?'));

        HttpUriRequest request = new HttpGet(realUrl);
        request.setHeader("X-Org-Id", orgId);

        return ApacheHttpClientUtils.execute(request, httpClient, new TrackerApiResponseHandler());
    }

    public boolean isUriAccessible(URI uri) {
        try {
            getStorageUri(uri);
            return true;
        } catch (UserException e) {
            return false;
        }
    }
}
