package ru.yandex.chemodan.app.docviewer.copy.resourcemanagers;

import java.io.IOException;
import java.net.URI;

import org.apache.http.HttpResponse;
import org.apache.http.client.ResponseHandler;

import ru.yandex.misc.io.InputStreamSourceUtils;

/**
 * @author yashunsky
 */
public class TrackerApiResponseHandler implements ResponseHandler<URI> {
    @Override
    public URI handleResponse(HttpResponse response) throws IOException {
        ResponseHandlerUtils.checkStatusCode(response);
        String content = InputStreamSourceUtils.wrap(response.getEntity().getContent()).readText("utf-8");
        if (content.startsWith("\"//") && content.endsWith("\"")) {
            content = content.substring(3, content.length() - 1);
        }
        if (!content.startsWith("http")) {
            content = "http://" + content;
        }
        return URI.create(content);
    }
}
