package ru.yandex.chemodan.app.docviewer.copy.resourcemanagers;

import java.io.IOException;
import java.net.URI;

import org.apache.http.Header;
import org.apache.http.HttpResponse;
import org.apache.http.HttpStatus;
import org.apache.http.client.ClientProtocolException;
import org.apache.http.client.ResponseHandler;
import org.joda.time.Instant;

import ru.yandex.bolts.collection.Option;
import ru.yandex.chemodan.app.docviewer.copy.StorageResourceInfo;
import ru.yandex.chemodan.app.docviewer.copy.provider.MulcaUrlProvider;
import ru.yandex.chemodan.app.docviewer.copy.storage.StorageId;
import ru.yandex.chemodan.app.docviewer.log.LoggerEventsRecorder;
import ru.yandex.chemodan.app.docviewer.states.ErrorCode;
import ru.yandex.chemodan.app.docviewer.states.UserException;
import ru.yandex.chemodan.app.docviewer.utils.HttpUtils2;
import ru.yandex.inside.mulca.MulcaId;
import ru.yandex.misc.lang.StringUtils;
import ru.yandex.misc.time.TimeUtils;

/**
 * @author akirakozov
 * use YaDiskCopierResponseHandlerVersioning instead!
 */
@Deprecated
public class YaDiskCopierResponseHandler implements ResponseHandler<StorageResourceInfo> {
    public static final String HEADER_X_TARGET_CONTENT_DISPOSITION = "X-Target-Content-Disposition";
    public static final String HEADER_X_TARGET_CONTENT_TYPE = "X-Target-Content-Type";

    private final URI uri;
    private final Instant startTime;

    public YaDiskCopierResponseHandler(URI uri, Instant startTime) {
        this.uri = uri;
        this.startTime = startTime;
    }

    private static Option<String> getHeaderO(HttpResponse response, String headerName) {
        final Header header = response.getFirstHeader(headerName);
        if (header != null && StringUtils.isNotEmpty(header.getValue())) {
            return Option.of(header.getValue());
        } else {
            return Option.empty();
        }
    }

    private static Option<String> trimQuotes(Option<String> stringO) {
        if (!stringO.isPresent()) {
            return Option.empty();
        }
        String s = stringO.get();
        return Option.of(s.length() >= 2 && s.startsWith("\"") && s.endsWith("\"")
                ? s.substring(1, s.length() - 1)
                : s);
    }

    @Override
    public StorageResourceInfo handleResponse(HttpResponse response) throws  IOException {
        LoggerEventsRecorder.saveGetMulcaIdEvent(
                uri, response.getStatusLine().toString(), TimeUtils.toDurationToNow(startTime));

        int statusCode = response.getStatusLine().getStatusCode();
        if (statusCode == HttpStatus.SC_NOT_FOUND) {
            throw new UserException(ErrorCode.FILE_NOT_FOUND);
        } else if (statusCode == HttpStatus.SC_FORBIDDEN) {
            throw new UserException(ErrorCode.FILE_IS_FORBIDDEN);
        } else if (statusCode != HttpStatus.SC_MOVED_PERMANENTLY
                && statusCode != HttpStatus.SC_MOVED_TEMPORARILY)
        {
            throw new UserException(ErrorCode.UNABLE_TO_RETRIEVE_FILE,
                    "No redirect to mulca from ya-disk, status-code: " + statusCode);
        }

        Option<String> location = getHeaderO(response, "location");
        if (location.isEmpty()) {
            throw new ClientProtocolException("Redirect response with no location");
        }

        Option<String> fileName = HttpUtils2.getFilenameFromContentDisposition(
                getHeaderO(response, HEADER_X_TARGET_CONTENT_DISPOSITION).getOrElse(""));

        StorageId storageId = StorageId.fromMulcaId(MulcaId.fromSerializedString(
                MulcaUrlProvider.getSerializedIdFromMulcaUrl(location.get())
        ));
        return new StorageResourceInfo(storageId, fileName,
                trimQuotes(getHeaderO(response, HEADER_X_TARGET_CONTENT_TYPE)), Option.empty());
    }

}
