package ru.yandex.chemodan.app.docviewer.copy.resourcemanagers;

import java.io.IOException;
import java.net.URI;

import org.apache.http.HttpResponse;
import org.apache.http.client.ResponseHandler;
import org.joda.time.Instant;

import ru.yandex.chemodan.app.docviewer.log.LoggerEventsRecorder;
import ru.yandex.inside.wmi.WmiAttachmentInfo;
import ru.yandex.inside.wmi.WmiResponseParser;
import ru.yandex.misc.io.InputStreamSourceUtils;
import ru.yandex.misc.time.TimeUtils;

/**
 * @author akirakozov
 */
public class YaMailCopierResponseHandler2 implements ResponseHandler<WmiAttachmentInfo> {
    private static final WmiResponseParser wmiResponseParser = new WmiResponseParser();

    private final URI uri;
    private final Instant startTime;
    private final String mid;
    private final String hid;

    public YaMailCopierResponseHandler2(URI uri, String mid, String hid, Instant startTime) {
        this.uri = uri;
        this.startTime = startTime;
        this.mid = mid;
        this.hid = hid;
    }

    @Override
    public WmiAttachmentInfo handleResponse(HttpResponse response) throws IOException {
        LoggerEventsRecorder.saveGetMulcaIdEvent(
                uri, response.getStatusLine().toString(), TimeUtils.toDurationToNow(startTime));

        ResponseHandlerUtils.checkStatusCode(response);

        String content = InputStreamSourceUtils.wrap(response.getEntity().getContent()).readText("utf-8");
        return wmiResponseParser.parseAttachmentInfo(mid, hid, content);
    }

}
