package ru.yandex.chemodan.app.docviewer.copy.storage;

import java.net.URI;

import lombok.AllArgsConstructor;
import lombok.Data;

import ru.yandex.bolts.collection.Option;
import ru.yandex.inside.mds.MdsFileKey;
import ru.yandex.inside.mulca.MulcaId;
import ru.yandex.inside.mulca.MulcaRange;
import ru.yandex.misc.lang.StringUtils;

/**
 * @author akirakozov
 */
@Data
@AllArgsConstructor
public class MdsStorageId implements StorageId {
    private final MdsFileKey mdsKey;
    private final String namespace;

    @Override
    public boolean isMulcaId() {
        return false;
    }

    @Override
    public boolean isRawUrl() {
        return false;
    }

    @Override
    public boolean isMdsKey() {
        return true;
    }
    public MulcaId getMulcaId() {
        throw new UnsupportedOperationException("Mds key storage id couldn't be mulca id");
    }

    @Override
    public String getRawUrl() {
        throw new UnsupportedOperationException("Mds key storage id couldn't be raw url");
    }

    @Override
    public Option<MulcaRange> getMulcaRange() {
        return Option.empty();
    }

    public MdsFileKey getMdsFileKey() {
        return mdsKey;
    }

    public String getNamespace() {
        return namespace;
    }

    public boolean isForwardableToSrw() {
        return true;
    }

    @Override
    public String getIdForUnistorageServiceRead2() {
        return namespace + "/" + getMdsFileKey().serialize();
    }

    @Override
    public int getCoupleId() {
        return mdsKey.getGroup();
    }

    @Override
    public String toString() {
        return mdsKey.toString();
    }

    public static MdsStorageId fromHttpUri(URI uri) {
        String namespaceAndKey = StringUtils.substringAfter(uri.getPath(), "get-");
        String namespace = StringUtils.substringBefore(namespaceAndKey, "/");
        String key = StringUtils.substringAfter(namespaceAndKey, "/");

        return new MdsStorageId(MdsFileKey.parse(key), namespace);
    }
}
