package ru.yandex.chemodan.app.docviewer.copy.storage;

import lombok.Data;

import ru.yandex.bolts.collection.Option;
import ru.yandex.inside.mds.MdsFileKey;
import ru.yandex.inside.mulca.MulcaId;
import ru.yandex.inside.mulca.MulcaRange;

/**
 * @author akirakozov
 */
@Data
public class MulcaStorageId implements StorageId {
    private static final String SRW_DISK_NAMESPACE = "disk";

    private final MulcaId mulcaId;
    private final Option<MulcaRange> mulcaRange;

    public MulcaStorageId(MulcaId mulcaId) {
        this(mulcaId, Option.empty());
    }

    public MulcaStorageId(MulcaId mulcaId, MulcaRange mulcaRange) {
        this(mulcaId, Option.of(mulcaRange));
    }

    private MulcaStorageId(MulcaId mulcaId, Option<MulcaRange> mulcaRange) {
        this.mulcaId = mulcaId;
        this.mulcaRange = mulcaRange;
    }

    @Override
    public boolean isMulcaId() {
        return true;
    }

    @Override
    public boolean isMdsKey() {
        return false;
    }

    @Override
    public boolean isRawUrl() {
        return false;
    }

    public MdsFileKey getMdsFileKey() {
        throw new UnsupportedOperationException("Storage id from mulca couldn't be mds key");
    }

    @Override
    public String getRawUrl() {
        throw new UnsupportedOperationException("Storage id from mulca couldn't be raw url");
    }

    public String getNamespace() {
        return SRW_DISK_NAMESPACE;
    }

    public boolean isForwardableToSrw() {
        if (mulcaRange.isPresent()) {
            return false;
        }

        String[] parts = serialize().split("\\.", 3);
        if (parts.length != 3) {
            return false;
        }
        String tail = parts[2];
        return tail.startsWith("E") && tail.contains(":");
    }

    @Override
    public String getIdForUnistorageServiceRead2() {
        return mulcaId.getStid();
    }

    @Override
    public int getCoupleId() {
        return 0;
    }

    @Override
    public String toString() {
        return mulcaId.toString();
    }
}
