package ru.yandex.chemodan.app.docviewer.copy.storage;

import ru.yandex.bolts.collection.Option;
import ru.yandex.inside.mds.MdsFileKey;
import ru.yandex.inside.mulca.MulcaId;
import ru.yandex.inside.mulca.MulcaRange;

/**
 * @author tolmalev
 */
public class RawUrlStorageId implements StorageId {
    private final String url;

    public RawUrlStorageId(String url) {
        this.url = url;
    }

    @Override
    public boolean isMulcaId() {
        return false;
    }

    @Override
    public boolean isMdsKey() {
        return false;
    }

    @Override
    public boolean isRawUrl() {
        return true;
    }

    @Override
    public MulcaId getMulcaId() {
        throw new UnsupportedOperationException("Raw url couldn't be mulca id");
    }

    @Override
    public Option<MulcaRange> getMulcaRange() {
        throw new UnsupportedOperationException("Raw url couldn't be mulca id");
    }

    @Override
    public MdsFileKey getMdsFileKey() {
        throw new UnsupportedOperationException("Raw url couldn't be mds id");
    }

    @Override
    public String getNamespace() {
        throw new UnsupportedOperationException("Raw url couldn't be mds id");
    }

    @Override
    public boolean isForwardableToSrw() {
        throw new UnsupportedOperationException("Raw url couldn't be mds id");
    }

    @Override
    public String getIdForUnistorageServiceRead2() {
        throw new UnsupportedOperationException("Raw url couldn't be mds id");
    }

    @Override
    public int getCoupleId() {
        throw new UnsupportedOperationException("Raw url couldn't be mds id");
    }

    @Override
    public String getRawUrl() {
        return url;
    }
}
