package ru.yandex.chemodan.app.docviewer.copy.storage;

import ru.yandex.bolts.collection.Option;
import ru.yandex.inside.mds.MdsFileKey;
import ru.yandex.inside.mulca.MulcaId;
import ru.yandex.inside.mulca.MulcaRange;

/**
 * @author akirakozov
 */
public interface StorageId {

    boolean isMulcaId();
    boolean isMdsKey();
    boolean isRawUrl();

    default String serialize() {
        return toString();
    }

    MulcaId getMulcaId();
    Option<MulcaRange> getMulcaRange();
    MdsFileKey getMdsFileKey();
    String getNamespace();
    boolean isForwardableToSrw();
    String getIdForUnistorageServiceRead2();
    int getCoupleId();
    String getRawUrl();

    enum Type {
        STID, MDS
    }

    static StorageId fromMulcaId(MulcaId mulcaId) {
        return new MulcaStorageId(mulcaId);
    }

    static StorageId fromMulcaId(MulcaId mulcaId, MulcaRange mulcaRange) {
        return new MulcaStorageId(mulcaId, mulcaRange);
    }

    static StorageId fromMdsKey(String namespace, MdsFileKey mdsFileKey) {
        return new MdsStorageId(mdsFileKey, namespace);
    }

    static StorageId fromRawUrl(String url) {
        return new RawUrlStorageId(url);
    }
}
