package ru.yandex.chemodan.app.docviewer.crypt;

import org.joda.time.Duration;

import ru.yandex.bolts.collection.ListF;
import ru.yandex.bolts.collection.Tuple2;
import ru.yandex.misc.digest.Md5;
import ru.yandex.misc.lang.Validate;

/**
 * @author ssytnik
 */
public class CryptUtils {
    private static final Duration EXPIRATION_THRESHOLD = Duration.standardSeconds(10);


    public static String calcToken(ListF<Object> params, String secret) {
        return Md5.A.digest(params.plus1(secret).mkString("-")).base64();
    }

    // returns (tokenWithHexTs; hexTs)
    public static Tuple2<String, String> calcTokenWithHexTs(ListF<Object> params, String secret) {
        String hexTs = Long.toHexString(System.currentTimeMillis());
        return Tuple2.tuple(calcToken(params.plus1(hexTs), secret), hexTs);
    }


    public static void validateToken(String token, ListF<Object> params, String secret) {
        Validate.isTrue(token.equals(calcToken(params, secret)), "wrong token: " + token);
    }

    public static void validateTokenWithHexTs(String token, String hexTs, Duration maxAliveTime, ListF<Object> params, String secret) {
        validateToken(token, params.plus1(hexTs), secret);
        validateTimestamp(maxAliveTime, hexTs);
    }


    static long getMillis(String hexTs) {
        return Long.valueOf(hexTs, 16);
    }

    static void validateTimestamp(Duration maxAliveTime, String hexTs) {
        long ageMillis = System.currentTimeMillis() - getMillis(hexTs);

        Validate.le( -EXPIRATION_THRESHOLD.getMillis(), ageMillis );
        Validate.le( ageMillis, maxAliveTime.getMillis() + EXPIRATION_THRESHOLD.getMillis() );
    }
}
