package ru.yandex.chemodan.app.docviewer.crypt;

import lombok.AllArgsConstructor;
import org.joda.time.Duration;

import ru.yandex.bolts.collection.Cf;
import ru.yandex.bolts.collection.Option;
import ru.yandex.bolts.collection.Tuple2;
import ru.yandex.inside.passport.PassportUidOrZero;

/**
 * @author nshmakov
 */
@AllArgsConstructor
public class TokenManager {

    private final String secret;
    private final String oldSecret;

    private static final Duration MAX_LINK_ALIVE_TIME = Duration.standardMinutes(10);

    public Tuple2<String, String> getTokenAndTs(Option<String> fileId, Option<String> fileUrl,
            Option<String> archivePath, PassportUidOrZero uid)
    {
        return CryptUtils.calcTokenWithHexTs(Cf.list(fileId.getOrElse(""), fileUrl.getOrElse(""),
                archivePath.getOrElse(""), uid), secret);
    }

    public void validateToken(String token, String hexTs, Option<String> fileId, Option<String> fileUrl,
            Option<String> archivePath, PassportUidOrZero uid)
    {
        try {
            CryptUtils.validateTokenWithHexTs(token, hexTs, MAX_LINK_ALIVE_TIME, Cf.list(fileId.getOrElse(""),
                fileUrl.getOrElse(""), archivePath.getOrElse(""), uid), secret);
        } catch (IllegalArgumentException e) {
            CryptUtils.validateTokenWithHexTs(token, hexTs, MAX_LINK_ALIVE_TIME, Cf.list(fileId.getOrElse(""),
                fileUrl.getOrElse(""), archivePath.getOrElse(""), uid), oldSecret);
        }
    }
}
