package ru.yandex.chemodan.app.docviewer.dao.cleanup;

import com.mongodb.BasicDBObject;
import com.mongodb.DBCollection;
import com.mongodb.DBObject;
import com.mongodb.DuplicateKeyException;
import lombok.AllArgsConstructor;
import org.joda.time.Instant;

import ru.yandex.bolts.collection.Option;
import ru.yandex.chemodan.app.docviewer.adapters.mongo.MongoDbAdapter;
import ru.yandex.chemodan.app.docviewer.adapters.mongo.MongoDbUtils;

/**
 * @author ssytnik
 */
@AllArgsConstructor
public class MongoCleanerTaskDao implements CleanerTaskDao {

    private static final String COLLECTION = "cleaner";

    private static final String COLUMN_ID = "_id";
    private static final String COLUMN_TIMESTAMP = "timestamp";
    private static final String COLUMN_HOST = "host";

    private final MongoDbAdapter mongoDbAdapter;

    private DBCollection getCollection() {
        return mongoDbAdapter.getDatabase().getCollection(COLLECTION);
    }

    @Override
    public Option<Instant> findTimestampById(String id) {
        DBObject dbObject = getCollection().findOne(new BasicDBObject(COLUMN_ID, id));
        return MongoDbUtils.getInstant(dbObject, COLUMN_TIMESTAMP);
    }

    @Override
    public void deleteById(String id) {
        DBObject query = new BasicDBObject(COLUMN_ID, id);
        getCollection().remove(query);
    }

    @Override
    public boolean saveAttempt(String id, Instant timestamp, String hostname) {
        try {
            DBObject query = new BasicDBObject(COLUMN_ID, id);
            // XXX timestamp.toDate() for readable date instead of unix time
            query.put(COLUMN_TIMESTAMP, timestamp.getMillis());
            query.put(COLUMN_HOST, hostname);
            getCollection().insert(query);
            return true;
        } catch (DuplicateKeyException e) {
            return false;
        }
    }

}
