package ru.yandex.chemodan.app.docviewer.dao.pdfImage;

import org.joda.time.Instant;

import ru.yandex.bolts.collection.Option;
import ru.yandex.bolts.function.Function1V;
import ru.yandex.chemodan.app.docviewer.utils.DimensionO;
import ru.yandex.chemodan.app.docviewer.utils.pdf.image.StoredImage;

/**
 * @author akirakozov
 */
public interface ImageDao {

    Option<StoredImage> findOne(String fileId, int oneBasedPageIndex, DimensionO size);
    Option<StoredImage> findOne(String fileId, String subkey);
    void updateLastAccessTime(String fileId, int oneBasedPageIndex, DimensionO size);
    void updateLastAccessTime(String fileId, String subKey);

    void savePdfImageIfNotExists(String fileId, int oneBasedPageIndex, DimensionO size, final String fileLinkString);
    void saveImageIfNotExists(String fileId, String subKey, String fileLinkString);

    void delete(String fileId, int oneBasedPageIndex, DimensionO size);
    void delete(String fileId, String subKey);

    void deleteByLastAccessLessBatch(Instant timestamp, Function1V<StoredImage> deleteHandler);

    void deleteByFileIdBatch(String fileId, Function1V<StoredImage> deleteHandler);
}
