package ru.yandex.chemodan.app.docviewer.dao.pdfImage;

import ru.yandex.bolts.collection.Tuple2;
import ru.yandex.chemodan.app.docviewer.utils.DimensionO;

/**
 * @author yashunsky
 */
public class ImageDaoUtils {
    public static String generateSubId(int oneBasedPageIndex, DimensionO size) {
        return "html-background-" + oneBasedPageIndex + "-" + size.toString("?");
    }

    public static Tuple2<Integer, DimensionO> parseSubId(String value) {
        // TODO: validate format
        String[] parts = value.split("-");
        if (parts.length == 4) {
            try {
                int page = Integer.parseInt(parts[2]);
                DimensionO size = DimensionO.parse(parts[3], "?");
                return Tuple2.tuple(page, size);
            } catch (Exception ignore) {
            }
        }
        return Tuple2.tuple(-1, DimensionO.NONE);
    }
}
