package ru.yandex.chemodan.app.docviewer.dao.pdfWarmup;

import java.util.Collection;
import java.util.LinkedList;

import com.mongodb.BasicDBObject;
import com.mongodb.DB;
import com.mongodb.WriteResult;
import org.joda.time.Duration;

import ru.yandex.chemodan.app.docviewer.utils.pdf.PdfWarmupMetrics;
import ru.yandex.commune.mongo.MongoCollection;
import ru.yandex.commune.mongo.MongoDefaultInterceptors;
import ru.yandex.commune.mongo.MongoHolder;

public class MongoPdfWarmupDao implements PdfWarmupDao {

    private static final String COLLECTION = "pdf-warmup-task";

    private final int blockSize;
    private final Duration ttl;

    private final MongoCollection<PdfWarmupTask, PdfWarmupTaskWithTime> collection;

    public MongoPdfWarmupDao(
            DB db,
            int blockSize,
            Duration ttl)
    {
        this.collection = new MongoCollection<>(
                db.getCollection(COLLECTION), PdfWarmupTaskWithTime.class,
                MongoHolder.defaultBenderConfiguration(),
                MongoDefaultInterceptors.defaultInterceptors());
        this.blockSize = blockSize;
        this.ttl = ttl;
    }

    @Override
    public Collection<PdfWarmupTask> createTasks(PdfWarmupTarget target,
            int zeroBasedStartPageIndex, int zeroBasedEndPageIndex)
    {
        return new LinkedList<PdfWarmupTask>() {{
            int blockSize = MongoPdfWarmupDao.this.blockSize;
            int startBlockIndex = zeroBasedStartPageIndex / blockSize;
            int endBlockIndex = zeroBasedEndPageIndex / blockSize;
            for (int i = startBlockIndex; i <= endBlockIndex; i++) {
                PdfWarmupTask task = new PdfWarmupTask(target, i, blockSize);
                PdfWarmupMetrics.totalBlocks.inc();
                WriteResult result = collection.insertOrUpdateById(task, new BasicDBObject("ctime", System.currentTimeMillis()));
                if (!result.isUpdateOfExisting()) {
                    PdfWarmupMetrics.warmBlocks.inc();
                    add(task);
                }
            }
        }};
    }

    @Override
    public void cleanup(Duration ttl) {
        collection.remove(new BasicDBObject("ctime", new BasicDBObject("$lte", System.currentTimeMillis() - ttl.getMillis())));
    }

    @Override
    public void cleanup() {
        cleanup(ttl);
    }

}
