package ru.yandex.chemodan.app.docviewer.dao.properties;

import ru.yandex.bolts.collection.MapF;
import ru.yandex.commune.mongo.bender.MongoId;
import ru.yandex.inside.passport.PassportUid;
import ru.yandex.misc.bender.annotation.BenderBindAllFields;
import ru.yandex.misc.lang.DefaultObject;

/**
 * @author akirakozov
 */
@BenderBindAllFields
public class Properties extends DefaultObject {
    @MongoId
    private final PassportUid uid;
    private MapF<String, String> properties;

    public Properties(PassportUid uid, MapF<String, String> properties) {
        this.uid = uid;
        this.properties = properties;
    }

    public PassportUid getUid() {
        return uid;
    }

    public MapF<String, String> getProperties() {
        return properties;
    }

    public void addProperty(String key, String value) {
        properties = properties.plus1(key, value);
    }
}
