package ru.yandex.chemodan.app.docviewer.dao.properties;

import com.mongodb.BasicDBObject;
import com.mongodb.DB;

import ru.yandex.bolts.collection.Cf;
import ru.yandex.bolts.collection.Option;
import ru.yandex.commune.mongo.MongoCollection;
import ru.yandex.commune.mongo.MongoDefaultInterceptors;
import ru.yandex.commune.mongo.MongoHolder;
import ru.yandex.commune.mongo.MongoQueryUtils;
import ru.yandex.inside.passport.PassportUid;

/**
 * @author akirakozov
 */
public class PropertiesDao {
    private static final String COLLECTION = "properties";

    private final MongoCollection<String, Properties> collection;

    public PropertiesDao(DB db) {
        collection = new MongoCollection<>(
                db.getCollection(COLLECTION), Properties.class,
                MongoHolder.defaultBenderConfiguration(),
                MongoDefaultInterceptors.defaultInterceptors());
    }

    public void saveProperties(Properties properties) {
        collection.insertOrUpdate(properties);
    }

    public void setProperty(PassportUid uid, String key, String value) {
        Option<Properties> props = findProperties(uid);
        if (props.isPresent()) {
            props.get().addProperty(key, value);
            saveProperties(props.get());
        } else {
            saveProperties(new Properties(uid, Cf.map(key, value)));
        }
    }

    public Option<Properties> findProperties(PassportUid uid) {
        return collection.findByRawId(uid.getUid());
    }

    public void removeProperties(PassportUid uid) {
        collection.remove(new BasicDBObject(MongoQueryUtils.ID_FIELD, uid.getUid()));
    }
}
