package ru.yandex.chemodan.app.docviewer.dao.results;

import lombok.Builder;
import lombok.Data;

import ru.yandex.bolts.collection.Option;
import ru.yandex.chemodan.app.docviewer.convert.DocumentProperties;
import ru.yandex.chemodan.app.docviewer.convert.TargetType;
import ru.yandex.chemodan.app.docviewer.convert.result.ConvertResultType;
import ru.yandex.chemodan.app.docviewer.convert.result.PagesInfo;

@Builder
@Data
public class ConvertSuccessArgs {
    private final String fileId;
    private final TargetType targetType;
    private final ConvertResultType type;
    private final String resultFileLink;
    private final long weight;
    private final long length;
    private final int pages;
    @Builder.Default private final Option<String> contentType = Option.empty();
    @Builder.Default private final Option<String> remoteFileId = Option.empty();
    @Builder.Default private final Option<PagesInfo> pagesInfo = Option.empty();
    @Builder.Default private final Option<String> rawPassword = Option.empty();
    private final DocumentProperties properties;
    private final String restoreUri;
}


