package ru.yandex.chemodan.app.docviewer.dao.results;

import org.joda.time.Instant;

import ru.yandex.bolts.collection.ListF;
import ru.yandex.bolts.collection.Option;
import ru.yandex.bolts.function.Function1V;
import ru.yandex.chemodan.app.docviewer.convert.TargetType;

public interface StoredResultDao {

    void delete(String fileId, TargetType convertTargetType);

    Option<StoredResult> find(String fileId, TargetType convertTargetType);

    Option<StoredResult> findAnyOfTypes(String fileId, ListF<TargetType> targetTypes);

    Iterable<StoredResult> findByLastAccessLess(Instant timestamp);

    void saveOrUpdateResult(ConvertSuccessArgs convertResultArgs);

    void saveOrUpdateResult(ConvertErrorArgs args);

    void updateLastAccessTime(String fileId, TargetType targetType);

    void updateWeight(String fileId, TargetType convertTargetType, long weight);

    void addExtractedText(String fileId, TargetType convertTargetType, String link);

    void setRestoreUri(String fileId, TargetType convertTargetType, String restoreUri);

    void deleteByLastAccessLessBatch(Instant timestamp, Function1V<StoredResult> deleteHandler);

    void handleEachResult(Function1V<StoredResult> handler);

    ListF<StoredResult> findByRemoteId(String remoteId);
}
