package ru.yandex.chemodan.app.docviewer.dao.rights;

import org.joda.time.Instant;

import ru.yandex.bolts.collection.ListF;
import ru.yandex.bolts.collection.Option;
import ru.yandex.chemodan.app.docviewer.copy.ActualUri;
import ru.yandex.inside.passport.PassportUidOrZero;

/**
 * @author vlsergey
 * @author ssytnik
 */
public interface UriRightsDao {
    void deleteUriRights(ActualUri uri);

    boolean findExistsUriRight(ActualUri uri, PassportUidOrZero uid);

    Option<ActualUri> findUriByFileIdAndUid(String fileId, PassportUidOrZero uid);

    ListF<ActualUri> findUrisAccessedByUid(PassportUidOrZero uid);

    void saveOrUpdateUriRight(ActualUri uri, PassportUidOrZero uid);

    void updateUriRights(ActualUri uri, String fileId);

    boolean validate(String fileId, PassportUidOrZero uid);

    void deleteByTimestampLessBatch(Instant timestamp);
}
