package ru.yandex.chemodan.app.docviewer.dao.sessions;

import org.joda.time.Duration;
import org.joda.time.Instant;

import ru.yandex.bolts.collection.Option;

/**
 * @author ssytnik
 */
public interface SessionDao {
    /**
    * @param sessionId session id
    * @param key       key, see {@link SessionKey#getPrefixAndKey()}
    * @return          raw value, see {@link SessionKey#toRawValue(String)}
    */
    Option<String> findValidValue(String sessionId, SessionKey key);

    /**
     * creates or updates record
     * @param sessionId session id, can be absent (empty)
     * @param key       key, see {@link SessionKey#getPrefixAndKey()}
     * @param value     raw value, see {@link SessionKey#toStoredValue(String)}
     * @return          non-empty (possibly new) session id
     */
    String createOrUpdate(String sessionId, SessionKey key, String value);

    void deleteByTimestampLessBatch(Instant timestamp);


    // for tests

    long count();

    long count(String sessionId, SessionKey key);

    Duration getSessionTtl();
}
