package ru.yandex.chemodan.app.docviewer.dao.uris;

import lombok.Data;
import org.apache.commons.lang3.StringUtils;
import org.joda.time.Instant;

import ru.yandex.bolts.collection.Cf;
import ru.yandex.bolts.collection.MapF;
import ru.yandex.bolts.collection.Option;
import ru.yandex.bolts.collection.Tuple2List;
import ru.yandex.chemodan.app.docviewer.convert.TargetType;
import ru.yandex.chemodan.app.docviewer.copy.ActualUri;
import ru.yandex.chemodan.app.docviewer.states.ErrorCode;
import ru.yandex.misc.bender.annotation.BenderBindAllFields;
import ru.yandex.misc.dataSize.DataSize;
import ru.yandex.misc.time.TimeUtils;

@Data
@BenderBindAllFields
public class StoredUri {
    public static final String SERP_LAST_ACCESS = "serp-last-access";

    private Option<String> contentType = Option.empty();
    private MapF<TargetType, Float> convertTargets = Cf.map();
    private Option<String> error = Option.empty();
    private Option<ErrorCode> errorCode = Option.empty();
    private Option<String> errorArchivePath = Option.empty();
    private Option<String> fileId = Option.empty();
    private Option<DataSize> contentSize = Option.empty();
    private Option<DataSize> maxContentSize = Option.empty();
    private Instant timestamp = TimeUtils.now();

    private Tuple2List<String, String> passwords = Tuple2List.tuple2List();

    private Option<Instant> serpLastAccess = Option.empty();

    private ActualUri uri;

    public Option<Object> getExtendedInfo(String key) {
        return key.equals(SERP_LAST_ACCESS) ? serpLastAccess.map(i -> (Object) i) : Option.empty();
    }

    public Option<Instant> getSerpLastAccess() {
        return serpLastAccess;
    }

    public void setExtInfo(MapF<String, Object> extInfo) {
        serpLastAccess = extInfo.getO(SERP_LAST_ACCESS).filterByType(Instant.class);
    }

    public void setContentSize(DataSize contentSize) {
        this.contentSize = Option.of(contentSize);
    }

    public void setMaxContentSize(DataSize maxContentSize) {
        this.maxContentSize = Option.of(maxContentSize);
    }

    public void setContentType(String contentType) {
        setContentType(Option.of(contentType));
    }

    public void setContentType(Option<String> contentType) {
        this.contentType = contentType;
    }

    public String getContentType() {
        return contentType.getOrElse(StringUtils.EMPTY);
    }

    public boolean hasErrors() {
        return error.isPresent() || errorCode.isPresent() || errorArchivePath.isPresent();
    }
}
