package ru.yandex.chemodan.app.docviewer.dao.uris;

import org.joda.time.Instant;

import ru.yandex.bolts.collection.ListF;
import ru.yandex.bolts.collection.Option;
import ru.yandex.bolts.collection.Tuple2List;
import ru.yandex.bolts.function.Function1V;
import ru.yandex.chemodan.app.docviewer.convert.TargetType;
import ru.yandex.chemodan.app.docviewer.copy.ActualUri;
import ru.yandex.chemodan.app.docviewer.dao.sessions.SessionKey.SessionCopyPassword;
import ru.yandex.chemodan.app.docviewer.states.ErrorCode;
import ru.yandex.misc.dataSize.DataSize;

public interface StoredUriDao {

    void delete(ActualUri uri);

    Option<StoredUri> find(ActualUri uri);
    // XXX use UriRightsDao
    @Deprecated
    ListF<StoredUri> findAllByFileId(String fileId);

    /**
     * @see SessionCopyPassword#getKey()
     * @return key to password hash mapping, sorted by key length
     */
    Tuple2List<String, String> getPasswordsSorted(ActualUri uri);

    /**
     * Same as {#link {@link #getPasswordsSorted(ActualUri)},
     * but 'uris' record can be absent (this can happen in /source)
     */
    Option<Tuple2List<String, String>> getPasswordsSortedO(ActualUri uri);

    void updatePasswords(ActualUri uri, Tuple2List<String, String> passwords);

    void updatePasswordRaw(ActualUri uri, String archivePath, String rawValue);

    void saveOrUpdateUri(ActualUri uri, Option<String> contentType,
            TargetType convertTargetType, Float priority);

    void updateUri(ActualUri uri, Option<String> reportedContentType, String fileId,
                   DataSize size, Option<Instant> serpLastAccess);

    void updateUriClean(ActualUri uri);

    void deleteByTimestampLessBatch(Instant timestamp, Function1V<StoredUri> deleteHandler);

    void deleteByTimestampLessBatch(Instant timestamp);

    void deleteErrorsByTimestampLessBatch(Instant timestamp);

    void updateUri(ActualUri uri, ErrorCode errorCode, String stackTrace, Option<String> errorArchivePath,
            Option<Long> contentSize, Option<Long> maxSize);
}
