package ru.yandex.chemodan.app.docviewer.dao.user;

import lombok.AllArgsConstructor;
import lombok.Builder;
import lombok.Data;
import lombok.NonNull;
import org.joda.time.Instant;

import ru.yandex.bolts.collection.Option;
import ru.yandex.chemodan.app.docviewer.copy.ActualUri;
import ru.yandex.chemodan.app.docviewer.dao.rights.MongoUriRightsDao;
import ru.yandex.chemodan.app.docviewer.storages.FileLink;
import ru.yandex.commune.mongo.bender.MongoId;
import ru.yandex.inside.passport.PassportUidOrZero;
import ru.yandex.misc.bender.annotation.Bendable;
import ru.yandex.misc.bender.annotation.BenderPart;
import ru.yandex.misc.time.TimeUtils;

@Data
@Bendable
@AllArgsConstructor
public class StoredUserDocument {

    @MongoId
    @BenderPart(name = MongoUserDocumentsDao.COLUMN_ID, strictName = true)
    private final String id;
    @BenderPart(name = MongoUserDocumentsDao.COLUMN_UID, strictName = true)
    @NonNull private final PassportUidOrZero uid;
    @BenderPart(name = MongoUserDocumentsDao.COLUMN_URI, strictName = true)
    @NonNull private final ActualUri uri;
    @BenderPart(name = MongoUserDocumentsDao.COLUMN_PREVIEW_URI, strictName = true)
    @NonNull private final String previewFileLink;
    @BenderPart(name = MongoUserDocumentsDao.COLUMN_LAST_ACCESS_TIME, strictName = true)
    private final Instant lastAccess;
    @BenderPart(name = MongoUserDocumentsDao.TYPE)
    private final Option<String> type;

    @Builder
    public StoredUserDocument(PassportUidOrZero uid, ActualUri uri, FileLink previewFileLink, String type) {
        this(MongoUriRightsDao.generateId(uri, uid), uid, uri, previewFileLink.getSerializedPath(), TimeUtils.now(), Option.ofNullable(type));
    }

    public StoredUserDocument(StoredUserDocument storedUserDocument, PassportUidOrZero uid) {
        this(MongoUriRightsDao.generateId(storedUserDocument.getUri(), uid), uid, storedUserDocument.getUri(),
                storedUserDocument.getPreviewFileLink(), TimeUtils.now(), storedUserDocument.getType());
    }
}
