package ru.yandex.chemodan.app.docviewer.dao.user;

import java.util.List;

import org.joda.time.Instant;

import ru.yandex.bolts.collection.ListF;
import ru.yandex.bolts.collection.Option;
import ru.yandex.bolts.function.Function1V;
import ru.yandex.chemodan.app.docviewer.copy.ActualUri;
import ru.yandex.inside.passport.PassportUidOrZero;

public interface UserDocumentsDao {

    List<StoredUserDocument> findDocuments(PassportUidOrZero uid, int limit, int offset);
    Option<StoredUserDocument> findDocument(PassportUidOrZero uid, ActualUri uri);
    void saveOrUpdateDocument(StoredUserDocument document);
    void updateAccessTime(PassportUidOrZero uid, ActualUri uri);
    void delete(StoredUserDocument storedUserDocument);
    void delete(PassportUidOrZero uid, ActualUri uri);

    ListF<StoredUserDocument> findDocumentByUrl(ActualUri uri);

    void deleteByLastAccessLessBatch(Instant timestamp, Function1V<StoredUserDocument> deleteHandler);
}
