package ru.yandex.chemodan.app.docviewer.dao.ydb;

import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

import ru.yandex.bolts.collection.ListF;
import ru.yandex.bolts.collection.Option;
import ru.yandex.bolts.function.Function;
import ru.yandex.bolts.function.Function1V;
import ru.yandex.chemodan.app.docviewer.adapters.mongo.MultithreadedBatchCallback;
import ru.yandex.chemodan.ydb.dao.pojo.OneTablePojoYdbDao;
import ru.yandex.commune.util.RetryUtils;
import ru.yandex.misc.db.q.SqlCondition;
import ru.yandex.misc.db.q.SqlLimits;
import ru.yandex.misc.db.q.SqlOrder;

/**
 * @author yashunsky
 */
public class DvYdbUtils {
    private static final Logger logger = LoggerFactory.getLogger(DvYdbUtils.class);

    private static final int MAX_BATCH_SIZE = 200;
    private static final int MAX_BACTH_CYCLES = 1_000_000;

    public static <T> void forEachBatch(
            OneTablePojoYdbDao<T> dao, SqlCondition condition,
            String index, String paginationColumn, Function<T, Object> paginationValueExtractor, int nThreads,
            Function1V<T> callbackHandler)
    {
        forEachBatch(dao, condition, Option.of(index), paginationColumn,
                paginationValueExtractor, nThreads, callbackHandler);
    }

    public static <T> void forEachBatch(
            OneTablePojoYdbDao<T> dao, SqlCondition condition,
            String paginationColumn, Function<T, Object> paginationValueExtractor, int nThreads,
            Function1V<T> callbackHandler)
    {
        forEachBatch(dao, condition, Option.empty(), paginationColumn,
                paginationValueExtractor, nThreads, callbackHandler);
    }

    public static <T> void forEachBatch(
            OneTablePojoYdbDao<T> dao, SqlCondition condition,
            Option<String> index, String paginationColumn, Function<T, Object> paginationValueExtractor, int nThreads,
            Function1V<T> callbackHandler)
    {
        try (MultithreadedBatchCallback<T> handler = new MultithreadedBatchCallback<>(callbackHandler, nThreads)) {
            forEachBatchInner(dao, condition, index, paginationColumn, paginationValueExtractor, handler);
        }
    }

    private static <T> void forEachBatchInner(OneTablePojoYdbDao<T> dao, SqlCondition mainCondition,
            Option<String> index, String paginationColumn, Function<T, Object> paginationValueExtractor,
            MultithreadedBatchCallback<T> batchCallbackHandler)
    {
        ListF<T> list;

        Option<Object> offset = Option.empty();

        int cycles = 0;
        do {
            SqlCondition condition;
            if (offset.isPresent()) {
                condition = mainCondition.and(SqlCondition.column(paginationColumn).gt(offset.get()));
            } else {
                condition = mainCondition;
            }

            list = RetryUtils.retry(3, () -> dao.find(
                    condition, index, SqlOrder.orderByColumn(paginationColumn), SqlLimits.first(MAX_BATCH_SIZE)));
            batchCallbackHandler.execute(list);
            offset = list.lastO().map(paginationValueExtractor);
            cycles++;
        } while (list.isNotEmpty() && cycles < MAX_BACTH_CYCLES);

        if (list.isNotEmpty()) {
            logger.error("forEachBatch seems infinite, review the code");
        }
    }

}
