package ru.yandex.chemodan.app.docviewer.dao.ydb;

import com.yandex.ydb.table.transaction.TransactionMode;
import lombok.AllArgsConstructor;
import lombok.Data;
import org.joda.time.Instant;

import ru.yandex.bolts.collection.Cf;
import ru.yandex.bolts.collection.Option;
import ru.yandex.chemodan.app.docviewer.dao.cleanup.CleanerTaskDao;
import ru.yandex.chemodan.ydb.dao.ThreadLocalYdbTransactionManager;
import ru.yandex.chemodan.ydb.dao.pojo.OneTablePojoYdbDao;
import ru.yandex.chemodan.ydb.dao.pojo.YdbClassAnalyzer;
import ru.yandex.misc.bender.annotation.BenderBindAllFields;

/**
 * @author yashunsky
 */
public class YdbCleanerTaskDao extends OneTablePojoYdbDao<YdbCleanerTaskDao.CleanerInfo> implements CleanerTaskDao {

    private static final String COLUMN_ID = "id";

    public YdbCleanerTaskDao(ThreadLocalYdbTransactionManager transactionManager)
    {
        super(transactionManager, "cleaner", YdbCleanerTaskDao.CleanerInfo.class, YdbClassAnalyzer
                .getDescription(YdbCleanerTaskDao.CleanerInfo.class, Cf.list(COLUMN_ID), Cf.map()));
    }

    @Override
    public Option<Instant> findTimestampById(String id) {
        return findOne(getColumnCondition(COLUMN_ID, id)).map(CleanerInfo::getTimestamp);
    }

    @Override
    public void deleteById(String id) {
        delete(getColumnCondition(COLUMN_ID, id));
    }

    @Override
    public boolean saveAttempt(String id, Instant timestamp, String hostname) {
        return transactionManager.executeInTx(() -> {
            if (findOne(getColumnCondition(COLUMN_ID, id)).isPresent()) {
                return false;
            } else {
                insert(new CleanerInfo(id, timestamp, hostname));
                return true;
            }
        }, TransactionMode.SERIALIZABLE_READ_WRITE);
    }

    @AllArgsConstructor
    @BenderBindAllFields
    @Data
    public static class CleanerInfo {
        private final String id;
        private final Instant timestamp;
        private final String hostname;
    }
}
