package ru.yandex.chemodan.app.docviewer.dao.ydb;

import lombok.AllArgsConstructor;
import lombok.Data;
import org.joda.time.Instant;

import ru.yandex.bolts.collection.Cf;
import ru.yandex.bolts.collection.Option;
import ru.yandex.chemodan.app.docviewer.dao.schedule.ScheduledTask;
import ru.yandex.chemodan.app.docviewer.dao.schedule.ScheduledTaskDao;
import ru.yandex.chemodan.ydb.dao.ThreadLocalYdbTransactionManager;
import ru.yandex.chemodan.ydb.dao.pojo.OneTablePojoYdbDao;
import ru.yandex.chemodan.ydb.dao.pojo.YdbClassAnalyzer;
import ru.yandex.misc.bender.annotation.BenderBindAllFields;

/**
 * @author yashunsky
 */
public class YdbScheduledTaskDao extends OneTablePojoYdbDao<YdbScheduledTaskDao.Task> implements ScheduledTaskDao {

    private static final String COLUMN_TASK_ID = "task_id";

    public YdbScheduledTaskDao(ThreadLocalYdbTransactionManager transactionManager, String name) {
        super(transactionManager, "schedule_" + name, Task.class, YdbClassAnalyzer
                .getDescription(Task.class, Cf.list(COLUMN_TASK_ID), Cf.map()));
    }

    @Override
    public Option<ScheduledTask> find(String taskId) {
        return findOne(getColumnCondition(COLUMN_TASK_ID, taskId)).map(Task::toSceduleTask);
    }

    @Override
    public void saveOrUpdateScheduleItem(String taskId, String hostname) {
        upsert(new Task(taskId, hostname));
    }

    @Override
    public void delete(String taskId) {
        delete(getColumnCondition(COLUMN_TASK_ID, taskId));
    }

    @AllArgsConstructor
    @BenderBindAllFields
    @Data
    public static class Task {
        private final String taskId;
        private final String hostname;
        private final Instant timestamp;

        public Task(String taskId, String hostname) {
            this(taskId, hostname, Instant.now());
        }

        public ScheduledTask toSceduleTask() {
            ScheduledTask result = new ScheduledTask();
            result.setTimestamp(timestamp);
            result.setHostname(Option.of(hostname));
            return result;
        }
    }
}
