package ru.yandex.chemodan.app.docviewer.dao.ydb;

import com.yandex.ydb.table.TableClient;
import com.yandex.ydb.table.stats.SessionPoolStats;
import org.joda.time.Duration;

import ru.yandex.misc.monica.annotation.GroupByDefault;
import ru.yandex.misc.monica.annotation.MonicaMetric;
import ru.yandex.misc.monica.annotation.MonicaStaticRegistry;
import ru.yandex.misc.monica.core.blocks.Value;
import ru.yandex.misc.monica.core.name.MetricGroupName;
import ru.yandex.misc.monica.core.name.MetricName;
import ru.yandex.misc.worker.spring.DelayingWorkerServiceBeanSupport;

/**
 * @author friendlyevil
 */
public class YdbSessionPoolMetrics extends DelayingWorkerServiceBeanSupport {
    private final TableClient tableClient;

    public YdbSessionPoolMetrics(TableClient tableClient) {
        this.tableClient = tableClient;
    }

    @MonicaMetric(description = "Session pool idle count")
    @GroupByDefault
    public static final Value<Integer> idleCount = new Value<>(0);

    @MonicaMetric(description = "Session pool disconnect count")
    @GroupByDefault
    public static final Value<Integer> disconnectCount = new Value<>(0);

    @MonicaMetric(description = "Session pool acquired count")
    @GroupByDefault
    public static final Value<Integer> acquiredCount = new Value<>(0);

    @MonicaMetric(description = "Session pool pending acquire count")
    @GroupByDefault
    public static final Value<Integer> pendingAcquireCount = new Value<>(0);

    static {
        MonicaStaticRegistry.register(
                YdbSessionPoolMetrics.class,
                new MetricGroupName(
                        "ydb_session_pool",
                        new MetricName("ydb", "session", "pool"),
                        "Ydb session pool"
                )
        );
    }

    @Override
    protected Duration defaultDelay() {
        return Duration.standardSeconds(1);
    }

    @Override
    protected void execute() throws Exception {
        SessionPoolStats poolStats = tableClient.getSessionPoolStats();
        idleCount.set(poolStats.getIdleCount());
        disconnectCount.set(poolStats.getDisconnectedCount());
        acquiredCount.set(poolStats.getAcquiredCount());
        pendingAcquireCount.set(poolStats.getPendingAcquireCount());
    }
}
