package ru.yandex.chemodan.app.docviewer.disk.mpfs;

import ru.yandex.bolts.collection.Option;
import ru.yandex.commune.json.JsonObject;
import ru.yandex.commune.json.JsonString;
import ru.yandex.commune.json.serialize.JsonParser;
import ru.yandex.misc.bender.Bender;
import ru.yandex.misc.bender.annotation.Bendable;
import ru.yandex.misc.bender.annotation.BenderPart;
import ru.yandex.misc.bender.parse.BenderParser;

/**
 * @author akirakozov
 * @deprecated replace with ru.yandex.chemodan.mpfs.MpfsClient
 */
public class MpfsUtils {

    public static final int HTTP_ERROR_OUT_OF_SPACE = 507;
    public static final int HTTP_ERROR_CONFLICT = 409;

    public static MpfsDownloadUrlResponse parseMpfsDownloadUrl(String response) {
        BenderParser<MpfsDownloadUrlResponse> parser = Bender.parser(MpfsDownloadUrlResponse.class);
        return parser.parseJson(response);
    }

    public static MpfsAsyncCopyResponse parseMpfsAsyncCopy(String response) {
        BenderParser<MpfsAsyncCopyResponse> parser = Bender.parser(MpfsAsyncCopyResponse.class);
        return parser.parseJson(response);
    }

    public static MpfsAsyncStoreExternalResponse parseMpfsAsyncStoreExternal(String response) {
        BenderParser<MpfsAsyncStoreExternalResponse> parser = Bender.parser(MpfsAsyncStoreExternalResponse.class);
        return parser.parseJson(response);
    }

    public static MpfsAsyncCopyResult parseMpfsExtractFileFromArchive(String response) {
        BenderParser<MpfsAsyncCopyResult> parser = Bender.parser(MpfsAsyncCopyResult.class);
        return parser.parseJson(response);
    }

    public static MpfsOperationStatus getOperationStatus(String response) {
        JsonObject resp = (JsonObject) JsonParser.getInstance().parse(response);
        return MpfsOperationStatus.R.valueOf(((JsonString) resp.getByPath("status")).getString());
    }

    public static String getCopiedResourcePathFromStatus(String response) {
        JsonObject resp = (JsonObject) JsonParser.getInstance().parse(response);
        return ((JsonString) resp.getByPath("resource", "path")).getString();
    }

    public static String getCopiedResourceMetaFromStatus(String response) {
        JsonObject resp = (JsonObject) JsonParser.getInstance().parse(response);
        return resp.getByPath("resource", "meta").toString();
    }

    public static String getCopiedResourceShortUrlFromStatus(String response) {
        JsonObject resp = (JsonObject) JsonParser.getInstance().parse(response);
        return ((JsonString) resp.getByPath("resource", "meta", "short_url")).getString();
    }

    public static Option<String> getHidFromPublicInfo(String response) {
        JsonObject resp = (JsonObject) JsonParser.getInstance().parse(response);
        return resp.getByPathO("resource", "meta", "hid")
                .map(jsonValue -> ((JsonString) jsonValue).getString());
    }

    public static Option<String> getHidFromInfo(String response) {
        JsonObject resp = (JsonObject) JsonParser.getInstance().parse(response);
        return resp.getByPathO("meta", "hid")
                .map(jsonValue -> ((JsonString) jsonValue).getString());
    }

    public static String getShortUrlFromPublicInfo(String response) {
        JsonObject resp = (JsonObject) JsonParser.getInstance().parse(response);
        return ((JsonString) resp.getByPath("resource", "meta", "short_url")).getString();
    }

    public static String getShortUrlFromInfo(String response) {
        JsonObject resp = (JsonObject) JsonParser.getInstance().parse(response);
        return ((JsonString) resp.getByPath("meta", "short_url")).getString();
    }

    public static Option<String> getPreviewUrlFromInfo(String response) {
        JsonObject resp = (JsonObject) JsonParser.getInstance().parse(response);
        return resp.getByPathO("meta", "custom_preview")
                .orElse(resp.getByPathO("resource", "meta", "custom_preview"))
                .map(jsonValue -> ((JsonString) jsonValue).getString());
    }

    public static String getZaberunUrl(String response) {
        JsonObject resp = (JsonObject) JsonParser.getInstance().parse(response);
        return ((JsonString) resp.getByPath("zaberun_url")).getString();
    }

    public static String getShortUrlFromSetPublicResponse(String response) {
        JsonObject resp = (JsonObject) JsonParser.getInstance().parse(response);
        return ((JsonString) resp.getByPath("short_url")).getString();
    }

    public static String getDownloadsFolderFromDefaultFolders(String response) {
        JsonObject resp = (JsonObject) JsonParser.getInstance().parse(response);
        return ((JsonString) resp.getByPath("downloads")).getString();
    }

    public static String getPathFromMakeSystemDirectory(String response) {
        JsonObject resp = (JsonObject) JsonParser.getInstance().parse(response);
        return ((JsonString) resp.getByPath("path")).getString();
    }

    public static MpfsOfficeActionCheckResponse getOfficeActionCheckResponse(String response) {
        BenderParser<MpfsOfficeActionCheckResponse> parser = Bender.parser(MpfsOfficeActionCheckResponse.class);
        return parser.parseJson(response);
    }

    @Bendable
    public static class MpfsDownloadUrlResponse {
        @BenderPart
        public int status;
        @BenderPart
        public MpfsDownloadUrlResult result;
    }

    @Bendable
    public static class MpfsAsyncCopyResponse {
        @BenderPart
        public int status;
        @BenderPart
        public MpfsAsyncCopyResult result;
    }

    @Bendable
    public static class MpfsAsyncStoreExternalResponse {
        @BenderPart
        public String oid;
        @BenderPart
        public String type;
    }

    @Bendable
    public static class MpfsDownloadUrlResult {
        @BenderPart
        public String file;
        @BenderPart
        public Option<String> digest;
    }

    @Bendable
    public static class MpfsAsyncCopyResult {
        @BenderPart
        public String oid;
        @BenderPart
        public String type;
    }

    @Bendable
    public static class MpfsOfficeActionCheckResponse {
        @BenderPart(name = "office_online_url", strictName = true)
        public String officeOnlineUrl;
        @BenderPart(name = "office_online_editor_type", strictName = true)
        public Option<String> officeOnlineEditorType;
    }

}
