package ru.yandex.chemodan.app.docviewer.disk.resource;

import lombok.Data;

import ru.yandex.bolts.collection.Option;
import ru.yandex.chemodan.app.docviewer.disk.mpfs.MpfsUrlHelper;
import ru.yandex.chemodan.app.docviewer.web.framework.exception.NotImplementedException;
import ru.yandex.inside.passport.PassportUidOrZero;

/**
 * @author akirakozov
 */
@Data
public class DiskPrivateFileId extends DiskResourceId {
    private final String path;

    public DiskPrivateFileId(String path) {
        this.path = path;
    }

    @Override
    public DiskResourceType getType() {
        return DiskResourceType.DISK_PRIVATE_FILE;
    }

    @Override
    public String getCopyToDiskUrl(
            MpfsUrlHelper mpfsUrlHelper, PassportUidOrZero uid, Option<String> fileName, boolean publish)
    {
        throw new NotImplementedException();
    }

    @Override
    public String getPath() {
        return path;
    }

    @Override
    public Service getService() {
        return Service.DISK;
    }

    @Override
    public String getServiceFileId() {
        return path;
    }
}
