package ru.yandex.chemodan.app.docviewer.disk.resource;

import lombok.Data;

import ru.yandex.bolts.collection.Option;
import ru.yandex.chemodan.app.docviewer.disk.mpfs.MpfsUrlHelper;
import ru.yandex.inside.passport.PassportUidOrZero;

/**
 * @author akirakozov
 */
@Data
public class DiskPublicFileId extends  DiskResourceId {
    private final String privateHash;

    public DiskPublicFileId(String privateHash) {
        this.privateHash = privateHash;
    }

    @Override
    public String getPrivateHash() {
        return privateHash;
    }

    @Override
    public DiskResourceType getType() {
        return DiskResourceType.DISK_PUBLIC_FILE;
    }

    @Override
    public String getCopyToDiskUrl(
            MpfsUrlHelper mpfsUrlHelper, PassportUidOrZero uid, Option<String> fileName, boolean publish)
    {
        return mpfsUrlHelper.getPublicCopyUrl(uid, privateHash, Option.empty());
    }

    @Override
    public Service getService() {
        return Service.PUBLIC;
    }

    @Override
    public String getServiceFileId() {
        return privateHash;
    }
}
